﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Threading;
using System.Net.Sockets;
using System.Net;

namespace KursBeispiele
{
    public delegate void AddTextDelegate(string m);

    public partial class Form1 : Form
    {
        const int PORT = 51481;

        AddTextDelegate atd;
        Thread serverThread;
        TcpClient[] clients;
        TcpListener server;

        public Form1()
        {
            atd = new AddTextDelegate(AddStatusText);
            InitializeComponent();
        }

        #region Server-Code

        //Startet den Server
        private void button1_Click(object sender, EventArgs e)
        {
            button3.Enabled = true;
            button1.Enabled = false;
            serverThread = new Thread(StartServer);
            serverThread.Start();
        }

        //Stoppt den Server
        private void button3_Click(object sender, EventArgs e)
        {
            button3.Enabled = false;
            button1.Enabled = true;
            AddStatusText("Server beendet!");

            foreach (TcpClient c in clients)
                if (c != null)
                    c.Close();

            server.Stop();
            serverThread.Abort();
            serverThread = null;
        }

        private void StartServer()
        {
            server = null;
            clients = new TcpClient[decimal.ToInt32(numericUpDown1.Value)];
            IPAddress ip = Dns.GetHostEntry("localhost").AddressList[0];
            server = new TcpListener(ip, PORT);
            server.Start();
            AddStatusText("Server hört zu!");

            //Alle Clients hinzufügen
            for (int i = 0; i < clients.Length; i++)
            {
                clients[i] = server.AcceptTcpClient();
                AddStatusText("Client akzeptiert! Es verbleiben noch " + (clients.Length - i - 1) + " Clients...");
            }

            AddStatusText("Alle Clients gefunden!");
        }

        #endregion

        #region Client-Code

        //Startet den Client
        private void button2_Click(object sender, EventArgs e)
        {
            try
            {
                IPHostEntry iphost = Dns.GetHostEntry(ip.Text);
                TcpClient tcpClient = new TcpClient(iphost.HostName, PORT);
                IPEndPoint ipe = (tcpClient.Client.RemoteEndPoint as IPEndPoint);
                tcpClient.Connect(ipe.Address, ipe.Port);
                AddStatusText("Verbunden!");
            }
            catch (Exception ex)
            {
                AddStatusText("Fehlgeschlagen!");
                AddStatusText(ex.Message);
            }
        }

        #endregion

        #region Allgemeines

        private void AddStatusText(string msg)
        {
            if (InvokeRequired)
                Invoke(atd, msg);
            else
            {
                status.AppendText(DateTime.Now.ToLongTimeString());
                status.AppendText(": ");
                status.AppendText(msg);
                status.AppendText(Environment.NewLine);
            }
        }

        private void Form1_FormClosing(object sender, FormClosingEventArgs e)
        {
            if (serverThread != null)
                button3_Click(sender, e);
        }

        #endregion
    }
}
